FUNCTION handlemcode()
    DIM temp AS FLOAT
    temp = TABLE(comms_mcode)
    SELECT_CASE temp
        CASE 0,5
            spindlestop() 'Spindle stop
        CASE 3
            spindlestartcw() 'Spindle CW
        CASE 4
            spindlestartccw() 'Spindle CCW
        CASE 8
            coolanton()
        CASE 9
            coolantoff()
        CASE 27
            tchome() 'tc home
        CASE 127
            tchomequick() 'tc home quick

        CASE 62
            mcode62()
        CASE 63
            mcode63()
        CASE 64
            mcode64()
        CASE 65
            mcode65()
        CASE 66
            mcode66()
        CASE 67
            mcode67()
        CASE 76
            mcode76()
        CASE 77
            mcode77()

    END_CASE
    TABLE(comms_task,0)
ENDFUNC

FUNCTION coolanton( )
    OP(output_lathecoolanton, ON)
ENDFUNC

FUNCTION coolantoff( )
    OP(output_lathecoolanton, OFF)
ENDFUNC

FUNCTION spindlestop()
    'Only stop the spindle if it was already running
    IF TABLE(table_spindlerunning) = ON THEN
        OP(output_spindleenable, OFF)
        WA(5000)
        TABLE(table_spindlerunning,OFF)
        DAC AXIS(0) = 0
        OP(output_guardlock, ON)
    ENDIF
ENDFUNC

FUNCTION spindlestartcw()
    IF ismachinesafe() THEN
        OP(output_guardlock, OFF)
        TABLE(table_spindlerunning,ON)
        OP(output_spindleenable, ON)
    ENDIF
ENDFUNC

FUNCTION spindlestartccw()
    OP(output_guardlock, OFF)
    OP(output_spindleenable, ON)
ENDFUNC

FUNCTION toolchange(tool AS INTEGER)
    IF TABLE(comms_atc) = 0 THEN
        spindlestop()
        VR(vr_tool) = tool
    ELSEIF VR(vr_tool) <> tool THEN
        tcchange(tool)
    ENDIF
ENDFUNC

FUNCTION mcode62()
    IF (VR(vr_machine) = microturn) OR (VR(vr_machine) = microturnpro) THEN
        OP(output_auxout1rmicroturn, ON)
    ELSEIF (VR(vr_machine) = turn270pro) OR (VR(vr_machine) = turn370pro) THEN
        OP(output_auxout1r, ON)
    ENDIF
ENDFUNC

FUNCTION mcode63()
    IF (VR(vr_machine) = microturn) OR (VR(vr_machine) = microturnpro) THEN
        OP(output_auxout2rmicroturn, ON)
    ELSEIF (VR(vr_machine) = turn270pro) OR (VR(vr_machine) = turn370pro) THEN
        OP(output_auxout2r, ON)
    ENDIF
ENDFUNC

FUNCTION mcode64()
    IF (VR(vr_machine) = microturn) OR (VR(vr_machine) = microturnpro) THEN
        OP(output_auxout1rmicroturn, OFF)
    ELSEIF (VR(vr_machine) = turn270pro) OR (VR(vr_machine) = turn370pro) THEN
        OP(output_auxout1r, OFF)
    ENDIF
ENDFUNC

FUNCTION mcode65()
    IF (VR(vr_machine) = microturn) OR (VR(vr_machine) = microturnpro) THEN
        OP(output_auxout2rmicroturn, OFF)
    ELSEIF (VR(vr_machine) = turn270pro) OR (VR(vr_machine) = turn370pro) THEN
        OP(output_auxout2r, OFF)
    ENDIF
ENDFUNC

FUNCTION mcode66()
    IF (VR(vr_machine) = microturn) OR (VR(vr_machine) = microturnpro) THEN
        WAIT UNTIL (IN(input_waitforinputr) = ON) OR cyclereset()
    ELSEIF (VR(vr_machine) = turn270pro) OR (VR(vr_machine) = turn370pro) THEN
        WAIT UNTIL (IN(input_input1waitr) = ON OR cyclereset())
    ENDIF
ENDFUNC

FUNCTION mcode67()
    IF (VR(vr_machine) = turn270pro) OR (VR(vr_machine) = turn370pro) THEN
        WAIT UNTIL (IN(input_input2vicer) = ON) OR cyclereset()
    ENDIF
ENDFUNC

FUNCTION mcode76()
    IF (VR(vr_machine) = microturn) OR (VR(vr_machine) = microturnpro) THEN
        WAIT UNTIL (IN(input_waitforinputr) = OFF) OR cyclereset()
    ELSEIF (VR(vr_machine) = turn270pro) OR (VR(vr_machine) = turn370pro) THEN
        WAIT UNTIL (IN(input_input1waitr) = OFF) OR cyclereset()
    ENDIF
ENDFUNC

FUNCTION mcode77()
    IF (VR(vr_machine) = turn270pro) OR (VR(vr_machine) = turn370pro) THEN
        WAIT UNTIL (IN(input_input2vicer) = OFF) OR cyclereset()
    ENDIF
ENDFUNC


